/* COPYRIGHT (c) 2014 Umut Acar, Arthur Chargueraud, and Michael
 * Rainey
 * All rights reserved.
 *
 * \file fib.hpp
 * \brief Fibonacci
 *
 */

#include <math.h>
#include <climits>
#include "sparray.hpp"

#ifndef _DEMO_FIB_H_
#define _DEMO_FIB_H_

namespace demo {

long fib_seq(long n) {
  if (n < 2) return n;
  return fib_seq(n-1) + fib_seq(n-2);
}

controller_type fib_contr("fib");

long fib_par(long n) {
  long result;
  par::cstmt(fib_contr, [&] { return 1l<<n; }, [&] {
    if (n < 2) result = n;
    else {
      long a,b;
      par::fork2([&] {
        a = fib_par(n-1);
      }, [&] {
        b = fib_par(n-2);
      });
      result = a+b;
    }
  }, [&] {
    result = fib_seq(n);
  });
  return result;
}

} /* namespace demo */

#endif /*! _DEMO_FIB_H_ */
