global data_dir

tp_tracks = [true_positive{:,1}];
fp_tracks = [false_positive{:,1}];
all_moving_tracks = [tp_tracks fp_tracks unknown];

moving_tracks = unique_tracks(moving_data);

false_neg = setdiff(tp_tracks, moving_tracks)
false_pos = intersect(fp_tracks, moving_tracks)
true_pos = intersect(tp_tracks, moving_tracks)

fprintf(1, 'false neg %d, false pos %d, true pos %d\n', ...
	length(false_neg), length(false_pos), length(true_pos));

new_moving = setdiff(moving_tracks, all_moving_tracks);
if (length(new_moving) > 0)
  fprintf(1, 'Strange, %d new moving tracks.\n', ...
  	  length(new_moving));
  new_moving		
end

newent = {length(false_pos) length(true_pos) ...
          length(false_neg) data_dir};

track_stats = [track_stats; newent];
