#include "float_trap.h"
#include "params.h"
#include "utils/message.h"
using namespace std;

#define ENABLE_FLOAT_TRAPS

#ifdef ENABLE_FLOAT_TRAPS

// this #define is required on the bus pc104 machines for some reason
#ifndef __USE_GNU
#define __USE_GNU
#endif

#include <fenv.h>
#endif

#define BAD_EXCEPTIONS (FE_DIVBYZERO | FE_OVERFLOW | FE_INVALID)

// Initialize float trap/exception support.
void ft_init () {
  switch (_float_exception_mode) {
  case 0:
  case 1:
    break;
  case 2:
    feenableexcept(BAD_EXCEPTIONS);
    break;
  default:
    ERROR("Bad float_exception_mode " <<_float_exception_mode);
  }
}

bool _ft_poll (char *file, int line, char *wot, char *context) {
  if (!_float_exception_mode) return false;
  char *e_name = NULL;
  if (fetestexcept(FE_DIVBYZERO)) {
    e_name = "DIVBYZERO";
  } else if (fetestexcept(FE_OVERFLOW)) {
    e_name = "OVERFLOW";
  } else if (fetestexcept(FE_INVALID)) {
    e_name = "INVALID";
  } 
  
  if (e_name) {
    cerr <<file <<":" <<line <<": Float exception " <<e_name
	 <<" " <<wot <<" " <<context <<endl;
    feclearexcept(BAD_EXCEPTIONS);
    return true;
  } else {
    return false;
  }
}
