#ifndef _DATMO_MODULE_H
#define _DATMO_MODULE_H

#include <ConfigSource/ConfigSource.h>
#include <ConfigSource/Module.h>
#include <utils/SymbolTable.h>
#include <LineScanner/LineScanner.h>
#include <VehState/VehState.h>
#include <ScanTrackOut/ScanTrackOut.h>
#include "datmo.h"
#include "gui.h"

class datmomod : public Module {
 public:
        datmomod(const char *spec);
        virtual ~datmomod( );
        virtual bool initialize(ConfigSource *config,
                                utils::SymbolTable *table);
        virtual bool run();
        virtual bool initializeDisplay(ConfigSource *config);
        virtual bool display();

 private:
        void make_local(const utils::Vec2d& src_vec,
                        float& out_x, float& out_y);
	void export_TrackVal (TrackVal &val, const PointVec &v2,
			      const Mat2d &vel_cov);
	void do_output_1 (ObjectTrack &track);
	bool do_output ();
	bool add_scans ();


 private:
        VehState    *_vs;
	vector<ScannerInfo *> _scanners;
        Datmo       *_datmo;
        Display     *_display;
        ScanTrackOut* _track_out;
        Gui         *_gui;

        double _min_x, _max_x, _min_y, _max_y;
	int _tracker_objects_limit;

        float _covariance[4][4];
        VehStateStruct _cur_state;
        utils::Transform _inv_cur_state;
        bool _exit_on_no_data;
        utils::Vector<TrackPoint> _out_points;

	// Keeps a running sum of the number of objects tracked recently for
	// load managing.  We try to maintain this at approximately zero, with
	// negative values meaning we are overrunning tracker_objects_limit.
	int _objects_limit_accum;

	double _sleep_for;
	int _read_strategy;
	double _last_add_time;

	// If non-null, log info about real-time scan acquisition here.
	ofstream *_scan_log;
	void do_scan_log ();
};


#endif
