#include <stdio.h>
#include <unistd.h>

#include <utils/Player.h>

int main()
{
  int data_i;
  double data_d;
  struct {
    int size;
    short* data;
  } array_data;
  
  __UTILS::Player player;

  player.expect("i", "int", &data_i);
  player.expect("d", "double", &data_d);
  player.expect("array", "{int, < short : 1 >}", &array_data);

  if (!player.open("test")) {
    printf("Could not open test for playing\n");
    exit(-1);
  }

  __UTILS::Time::init();
  __UTILS::Time::useDiscreteTime();
  __UTILS::Time::setTimeStep(0.05);

  player.setZero(__UTILS::Time::getTimeOfDay());

  __UTILS::Time log_time;
  long sec, usec;
  while (1) {
    log_time =  __UTILS::Time::getTimeOfDay();
    log_time.getValue(sec, usec);
    printf("At time %ld %ld: ", sec, usec);
    if (!player.get(log_time))
      break;
    log_time.getValue(sec, usec);
    printf("%ld %ld: %d %f %d %d\n",
           sec, usec, data_i, data_d, array_data.size, array_data.data[0]);
    __UTILS::Time::stepTime();
  }
}
    
