#include <stdio.h>
#include <string.h>

#include <utils/ConfigFile.h>
#include <utils/Input.h>
#include <utils/SpecElem.h>
#include "ConfigParser.h"

int main(int argc, char** argv) 
{
  const char* file_name;
  if (argc < 2)
    file_name = "test.conf";
  else
    file_name = argv[1];
  __UTILS::ConfigFile config;
  __UTILS::Input input;
  __UTILS::ConfigParser parser(input, (__UTILS::StructElem*) config.getRoot());
  __UTILS::SpecElem::initClass();

  if (!input.openFile(file_name)) {
    printf("Cannot open test file %s\n", file_name);
    exit(-1);
  }
  parser.yyparse();
}
