#include <math.h>
#include <unistd.h>

#include <utils/Logger.h>
#include <utils/ConfigFile.h>

#include <utils/Time.h>

#define MAX_ARRAY 50

int main()
{
  int data_i;
  short data_s;
  double data_d;
  struct {
    int size;
    short* data;
  } array_data;
  array_data.data = new short[MAX_ARRAY];
  
  __UTILS::Logger logger;

  logger.declare("i", "int", &data_i);
  logger.declare("s", "short", &data_s);
  logger.declare("d", "double", &data_d);
  logger.declare("array", "{int, < short : 1 >}", &array_data);
  __UTILS::ConfigFile params;
  params.parse("struct DataFormat "
               "{ int version_major = 1; int version_minor=0;}");

  logger.open("test", params);

  __UTILS::Time now = __UTILS::Time::getTimeOfDay();
  int index = 0;
  for (int i=0;i<10;i++) {
    printf("I %d\n", i);
    for (double th=M_PI; th>-M_PI; th = th-0.05) {
      data_i = i;
      data_s = i*2;
      data_d = th;
      array_data.size = (index%(MAX_ARRAY-1)) + 1;
      for (int j=0;j<array_data.size;j++) {
        array_data.data[j] = j;
      }
      logger.log(now);
      index++;
      now += utils::Time(0.001);
    }
    now += 10.0;
  }
}
