///////////////////////////////////////////////////////////////////////////////
//
//                               VerbatimSpec.h
//
// A subclass of CustomPtrSpec for dealing with "verbatim" entries,
// essentially treated as strings except they are read and printed enclosed in
// brackets, not quotes.
//
// Classes defined for export:
//   VerbatimSpec
//
///////////////////////////////////////////////////////////////////////////////

#ifndef utils_verbatim_spec_h
#define utils_verbatim_spec_h

#include <utils/formatting/CustomPtrSpec.h>

__UTILS_BEGIN_NAMESPACE

class VerbatimSpec : public CustomPtrSpec {
    UTILS_BASE_HEADER(VerbatimSpec);

  public:
    VerbatimSpec();

    virtual bool applyAction(FormatAction* action);

    static void initClass();
};

__UTILS_END_NAMESPACE

#endif
