///////////////////////////////////////////////////////////////////////////////
//
//                                 VectorSpec.h
//
// Declares the custom format specifier which indicates a pointer to an
// instance of Vector.
//
// Classes implemented for export:
//     VectorSpec
//     SizedList - a subclass of Vector<char> which allows us to fool with
//                 the internals to read in lists generically
//
///////////////////////////////////////////////////////////////////////////////

#ifndef utils_list_spec_h
#define utils_list_spec_h

#include <utils/Vector.h>
#include <utils/formatting/CustomPtrSpec.h>

__UTILS_BEGIN_NAMESPACE

class VectorSpec : public CustomPtrSpec {
    UTILS_BASE_HEADER(VectorSpec);

  public:
    VectorSpec(FormatSpec* fmt = (FormatSpec*) NULL);
    virtual ~VectorSpec();

    virtual FormatSpec* processParameters(FormatParser*);
    virtual bool applyAction(FormatAction* action);

    void setFormat(FormatSpec*);
    FormatSpec* getFormat() const { return _fmt; }

    static void initClass();

  private:
    bool deleteList(FormatAction*);
    bool printList(FormatAction*);
    bool readList(FormatAction*);
    bool printListFormat(FormatAction*);
    bool listFormatEquals(FormatAction*);
    bool packList(FormatAction*);
    bool unpackList(FormatAction*);
    bool getBufferSize(FormatAction*);
    bool makeCopy(FormatAction*);
    bool makeClone(FormatAction*);
    bool listEquals(FormatAction*);

  private:
    FormatSpec* _fmt;   // the element format specifier
};

// a subclass of Vector<char> which allows us to fool with
// the internals to read in lists generically
class SizedList : public Vector<char> {
  public:
    SizedList(int num_bytes=10) : Vector<char>(num_bytes) {}
    // make room for size_type bytes, and return where we made room
    char* makeRoom(int size_type) {
        setMaxNum(_num_elems + size_type);
        char* result = _data + _num_elems;
        _num_elems += size_type;
        return result;
    }
    // make this list look like a Vector<struct of size size_type>
    // if size not equal -1, then we finish by setting the number of elemens
    // to size
    void finishSized(int size_type, int size = -1) {
        if (size == -1)
            _num_elems /= size_type;
        else
            _num_elems = size;
        _max_elems /= size_type;
    }
};

__UTILS_END_NAMESPACE

#endif

    
