///////////////////////////////////////////////////////////////////////////////
//
//                              PrintAction.h
//
// Defines the print format action.  The print format action outputs data
// as specified by format specifiers to a FILE.
//
// Classes defined for export:
//   PrintAction - the print format action class
//
///////////////////////////////////////////////////////////////////////////////

#ifndef utils_print_action_h
#define utils_print_action_h

#include <stdio.h>
#include <utils/Output.h>
#include <utils/formatting/DataAction.h>

__UTILS_BEGIN_NAMESPACE

class PrintAction : public DataAction {
    UTILS_BASE_HEADER(PrintAction);
  public:
    PrintAction(void* data = NULL, FILE* fp = (FILE*) NULL);
    PrintAction(void* data, const Output& output);
    PrintAction(void* data, void* buffer, int initSize,
                  bool (*resizeProc)(void*&, int&,
                                       char*&, void*) = 0L,
                  void* callback_data = NULL, int offset = 0);

    Output& getOutput() { return _output; }
    
    virtual bool actInt();
    virtual bool actShort();
    virtual bool actLong();
    virtual bool actFloat();
    virtual bool actDouble();
    virtual bool actChar();
    virtual bool actString();
    virtual bool actLength(int size);
    virtual bool actPtr(FormatSpec* fmt);
    virtual bool actStructElem(int i,int size, FormatSpec** elems);
    virtual bool startStruct();
    virtual bool endStruct();
    virtual bool actFixedArray(const Vector<int>& sizes, FormatSpec* fmt);
    virtual bool actVarArray(StructSpec* parent,
                             const Vector<int>& indices,
                             FormatSpec* fmt);

    static bool print(FormatSpec* spec, void* data,
                        const Output& output);
    static void initClass();

  private:
    Output _output;
};
    
__UTILS_END_NAMESPACE

#endif
