///////////////////////////////////////////////////////////////////////////////
//
//                               FormConfig.h
//
// Defines variables which determine how to pack and unpack data given
// different machines
//
// Preprocessor variables exported
//    ALIGN - the alignment of data in structures.  Could be ALIGN_WORD,
//         ALIGN_LONGEST, or ALIGN_INT
//    BYTE_ORDER - the byte order of numbers, could be LITTLE_ENDIAN or
//         BIG_ENDIAN
//
///////////////////////////////////////////////////////////////////////////////

#ifndef utils_form_config_h
#define utils_form_config_h

#include <utils/Basic.h>

__UTILS_BEGIN_NAMESPACE

typedef enum 
{
  /* 
   * Align things on word boundaries unless next item uses an odd number 
   * of bytes.
   */
  PACKED_ALIGNMENT = 0x00,
  
  /* 
   * Align things on word boundaries unless next item uses an odd number 
   * of bytes.
   */
  WORD_ALIGNMENT = 0x01,
  
  /* 
   * Align things on the boundary of the longest type in the struct.
   */
  LONGEST_ALIGNMENT = 0x02,
  
  /* 
   * Align things on the boundary of the longest type in the struct, up to the
   * size of an int.
   */
  INT_ALIGNMENT = 0x04
} ALIGNMENT_TYPE;

#define ALIGN_UNDEFINED -1
#define ALIGN_PACKED  0x00
#define ALIGN_WORD    0x01
#define ALIGN_LONGEST 0x02
#define ALIGN_INT     0x04

#undef LITTLE_ENDIAN
#undef BIG_ENDIAN
#undef PDP_ENDIAN

#define	LITTLE_ENDIAN	0	/* least-significant byte first (vax) */
#define	BIG_ENDIAN	1	/* most-significant byte first (IBM, net) */
#define	PDP_ENDIAN	2	/* LSB first in word, MSW first in long (pdp) */
#define BYTE_ORDER_UNDEFINED -1

#undef BYTE_ORDER

/* ignore the whole PDP endian thing for now */
#if defined(WORDS_BIGENDIAN)
#define BYTE_ORDER BIG_ENDIAN
#else
#define BYTE_ORDER LITTLE_ENDIAN
#endif

#define ALIGN STRUCTURE_ALIGN

#define NETWORK_BYTE_ORDER BIG_ENDIAN
/* Use this for testing.*/
/*#define NETWORK_BYTE_ORDER LITTLE_ENDIAN*/
#define NETWORK_ALIGNMENT ALIGN_WORD

#define ODDPTR(x) ((x) & 1)

__UTILS_END_NAMESPACE

#endif
