///////////////////////////////////////////////////////////////////////////////
//
//                               DeleteAction.h
//
// Implements an action which deletes the memory associated with a 
// formatted data structure
//
// Classes defined for export:
//     DeleteAction
//     
///////////////////////////////////////////////////////////////////////////////

#ifndef utils_delete_action_h
#define utils_delete_action_h

#include <utils/formatting/DataAction.h>

__UTILS_BEGIN_NAMESPACE

class DeleteAction : public DataAction {
    UTILS_BASE_HEADER(DeleteAction);
  public:
    DeleteAction(void* data=0, unsigned char* buf=0L, int buf_size=0);

    void reset(void* data, unsigned char* buffer = 0L, int buf_size=0) {
        DataAction::resetData(data); _buffer = buffer; _buf_size = buf_size;
    }
    unsigned char* getBuffer() const { return _buffer; }
    int getBufSize() const { return _buf_size; }

    virtual bool actString();
    virtual bool actPtr(FormatSpec* fmt);
    virtual bool actFixedArray(const Vector<int>& sizes, FormatSpec* fmt);
    virtual bool actVarArray(StructSpec* parent,
                             const Vector<int>& indices, FormatSpec* fmt);

    static bool deleteStruct(FormatSpec* spec, void* data,
                               unsigned char* buf=0L, int buf_size=0);
    static bool deleteData(FormatSpec* spec, void* data,
                             unsigned char* buf=0L, int buf_size=0);
    static void initClass();

  private:
    // returns true if data is in the buffer
    bool inBounds(unsigned char*) const;

  private:
    unsigned char* _buffer;  // the buffer which data might be in 
    int _buf_size;           // the size of the buffer
};
    
__UTILS_END_NAMESPACE

#endif
