///////////////////////////////////////////////////////////////////////////////
//
//                               CopyAction.h
//
// Implements an action which copys data from one block structured data
// to another
//
// Classes defined for export:
//     CopyAction
//     
///////////////////////////////////////////////////////////////////////////////

#ifndef utils_copy_action_h
#define utils_copy_action_h

#include <utils/formatting/DataAction.h>

__UTILS_BEGIN_NAMESPACE

class CopyAction : public DataAction {
    UTILS_BASE_HEADER(CopyAction);
  public:
    CopyAction(void* data = NULL, void* dest = NULL);

    void advance(int);
    void toDest(void*, int);

    virtual bool actInt() { return copyBytes(sizeof(int)); }
    virtual bool actShort() { return copyBytes(sizeof(short)); }
    virtual bool actLong() { return copyBytes(sizeof(long)); }
    virtual bool actFloat() { return copyBytes(sizeof(float)); }
    virtual bool actDouble() { return copyBytes(sizeof(double)); }
    virtual bool actChar() { return copyBytes(sizeof(char)); }
    virtual bool actLength(int size) { return copyBytes(size); }

    virtual bool actString();
    virtual bool actPtr(FormatSpec*);

    virtual bool actStructElem(int i, int num_elems, FormatSpec** elems);
    virtual bool actFixedArray(const Vector<int>& sizes, FormatSpec* fmt);
    virtual bool actVarArray(StructSpec*,
                             const Vector<int>&, FormatSpec*);

    static bool copy(FormatSpec*, void*, void*);
    static void* copy(FormatSpec*, void*);

    static void initClass();

  private:
    bool copyBytes(int);

  private:
    DataAction _dest;    // holds the pointers for the destination data
};

__UTILS_END_NAMESPACE

#endif

