#ifndef UTILS_UNKNOWN_ELEM_H
#define UTILS_UNKNOWN_ELEM_H

#include <utils/ConfigElem.h>
#include <utils/StringDict.h>
#include <utils/Vector.h>

__UTILS_BEGIN_NAMESPACE

struct StructElem;

///////////////////////////////////////////////////////////////////////////
// UnknownElem - class for untyped data terminated by ; to be parsed later
// UnknownElem's must store their context and names because when the user 
// invokes UnknownElem::getValue, the UnknownElem is read as the type that
// the user requests, and a new element of the appropriate type is created
// and then context->name must be reset to the new element from the current
// unknown element.
class UnknownElem : public StringElem {
    UTILS_BASE_ABSTRACT_HEADER(UnknownElem);
public:
    UnknownElem(StructElem* context, const char* name,
                UnknownElem* other=NULL);

    // can't set unknown values
    virtual bool setValue(Type type, void* data, int num_values) {
      return false;
    }

    virtual int getValue(Type dest_type, void* data, int max_num=1) const;
    virtual void writePrim(Output& output, int index);

    const char* getName() const { return _name.getString(); }
    StructElem* getContext() const { return _context; }

    static void initClass();
  
private:
    StructElem* _context;  // StructElem the unknown occurs within
    String _name;          // the name of the unknown element
};

__UTILS_END_NAMESPACE

#endif
