/***************************************************************************

                                StructElem.h

  Defines the structure element of a ConfigFile (see ConfigFile.h
  and ConfigFile.cc).  This is really the heart of a ConfigFile, where
  names are paired with values

  Classes defined for export:
    StructElem - the structure element

***************************************************************************/

#ifndef UTILS_STRUCT_ELEM_H
#define UTILS_STRUCT_ELEM_H

#include <utils/ConfigElem.h>
#include <utils/StringDict.h>
#include <utils/Vector.h>

__UTILS_BEGIN_NAMESPACE

class Input;
class Output;
class String;

class StructElem : public ConfigElem {
    UTILS_BASE_HEADER(StructElem);
public:
    StructElem();
    virtual ~StructElem();

    virtual void clear();
    virtual bool parseVal(const char* val) { return false; }
    virtual void writeData(Output& output);
    virtual bool readData(Input& input);
    virtual int getValue(Type dest_type, void* data, int max_num=1) const;
    virtual bool setValue(Type dest_type, void* data, int num_values);
    virtual bool copy(ConfigElem* src);
    virtual unsigned char* getData() { return (unsigned char*) &_me; }
    bool merge(ConfigElem* src);

    ConfigElem* lookup(const char*) const;
    void set(const char*, ConfigElem*);
    ConfigElem* makeElem(Input&, String&, bool ignore_duplicates=false,
                         bool create_new=true);
    ConfigElem* makeElem(const char*, bool ignore_duplicates=false,
                         bool create_new=true);

    const StringDict<ConfigElem*>& entries() const { return _dict; }
    StringDict<ConfigElem*>& entries() { return _dict; }

    static void initClass();

protected:
    static void write_struct_elem(const char* key, ConfigElem* elem,
                                  void* data);

protected:
    StringDict<ConfigElem*> _dict;  // the element dictionary
    char* _output_buf;     // the output buffer, if converted to strings
    int _size_output;      // the size of the output buffer
    StructElem* _me;       // used to return getData
};

///////////////////////////////////////////////////////////////////////////
// StructArrayElem - holds an array of StructElem's
class StructArrayElem : public ConfigElem {
  UTILS_BASE_HEADER(StructArrayElem);
public:
    StructArrayElem();
    virtual ~StructArrayElem();

    virtual void clear();
    virtual bool parseVal(const char* val) { return false; }
    virtual void writeData(Output& output);
    virtual bool readData(Input& input);
    virtual int getValue(Type dest_type, void* data, int max_num=1) const;
    virtual bool setValue(Type dest_type, void* data, int num_values);
    virtual int numValues() const { return _array.numElems(); }
    virtual bool copy(ConfigElem* src);
    virtual unsigned char* getData() {
      return (unsigned char*) _array.getData();
    }

    void add(StructElem*);
    StructElem* get(int index);

    static void initClass();

private:
    Vector<StructElem*> _array;  // the array of structures
};

__UTILS_END_NAMESPACE

#endif
