///////////////////////////////////////////////////////////////////////////////
//
//                               SpecElem.h
//
// Defines class for reading interface specifications (see Generator.cc)
//
// Classes implemented for export:
//   SpecElem - a config elem used to read in interface specifications
//
// Classes defined and implemented for internal use
//   Interface - class for creating a reconfigurable interface
//   CreatorCallback - callback for using a function to create a interface
//
///////////////////////////////////////////////////////////////////////////////

#ifndef UTILS_SPEC_ELEM_H
#define UTILS_SPEC_ELEM_H

#include <utils/StructElem.h>

__UTILS_BEGIN_NAMESPACE

class SpecElem : public StructElem {
    UTILS_BASE_HEADER(SpecElem);
public:
    SpecElem();
    virtual ~SpecElem();

    virtual bool parseVal(const char* val);
    virtual void writeData(Output& output);
    virtual int getValue(Type dest_type, void* data, int max_num=1) const;

    const char* getTag() const;

    static void initClass();

protected:
    static void write_struct_elem(const char* key, ConfigElem* elem,
                                  void* data);
};

__UTILS_END_NAMESPACE

#endif

