///////////////////////////////////////////////////////////////////////////////
//
//                               Mutex.h
//
// Declares an abstract class for a mutal exclusion semaphore, as well as a 
// global function pointer for generating mutexes.  
//
// Classes defined for export:
//     Mutex
//
// Types defined for export
//     MutexCreator
//
// Globals defined for export
//     Mutex_Factory - Mutex creator for library thread-safeness
//
///////////////////////////////////////////////////////////////////////////////

#ifndef UTILS_MUTEX_H
#define UTILS_MUTEX_H

#include <utils/Basic.h>

__UTILS_BEGIN_NAMESPACE

class Mutex {
  public:
    virtual bool lock() = 0;     // acquire a lock on the semaphore
    virtual bool unlock() = 0;   // release a lock on the semaphore
};

typedef Mutex* (*MutexCreator)();

extern MutexCreator Mutex_Factory;

__UTILS_END_NAMESPACE

#endif
    
