/***************************************************************************

                               Managed.h

 Defines the Managed class.  This class provides  a reference counting 
 system for memory management for all classes descended from it.  If the 
 environment variable TRACE_REFERENCES is set, Managed prints out copious 
 information about what is getting referenced and unreferenced

 Classes defined for export:
     Managed

***************************************************************************/

#ifndef UTILS_MANAGED_H
#define UTILS_MANAGED_H

#include <utils/Basic.h>

#ifdef __cplusplus

__UTILS_BEGIN_NAMESPACE

template <class T> class Vector;

#define STATIC_REF_COUNT -100

class Managed {
  public:
    virtual ~Managed();

    // Adds a reference to an instance
    // This generates a C++ warning.
    void			ref() const;

    // Removes a reference to an instance, deleting it if count is now 0
    void			unref() const;

    // Removes a reference to an instance, NOT deleting it if count is now 0
    void			unrefNoDelete() const;

    // makes this static, i.e., ref'ing and unref'ing have no effect
    void makeStatic();

    // static routines for deferring and then performing deletions that come
    // as a result of references going to 0
    static void deferDeletions();
    static void undeferDeletions();
    static void resetDeletions();
    static void flushReferences();
    static int deferralStatus() { return _deferral_status; }

    virtual const char* getTypeName() const { return "Untyped"; }
    virtual const char* getName() const { return "Unnamed"; }

    static void ref(Managed* o) { if (o) o->ref(); }
    static void unref(Managed* o) { if (o) o->unref(); }

  protected:
    // Constructor is protected - this is an abstract class
    Managed();

  public:  // but shouldn't be used

    // Returns current reference count
    int			getRefCount() const	{ return _ref_count; }

    static bool traceReferences;  // set to true if we are tracing references

    static void initClass();

  private:
    // Reference count
    int			_ref_count;

    static int _deferral_status;     // if > 0, we are deferring deletions
    static Vector<Managed*>* _deferred_deletes;  // list of deferred deletions
};

__UTILS_END_NAMESPACE

#endif

#endif
