/***************************************************************************

                                Logger.h

  Defines a class to output values tagged with times using the
  CannedDataWrite class

  Classes implemented for export:
    Logger - the logging class

***************************************************************************/

#ifndef UTILS_LOGGER_H
#define UTILS_LOGGER_H

#include <utils/CannedDataAccess.h>
#include <utils/List.h>
#include <utils/Time.h>
#include <utils/formatting/FormatParser.h>

__UTILS_BEGIN_NAMESPACE

class LogElem;
class ConfigFile;

class Logger {
 public:
  Logger();
  ~Logger();

  void close();
  bool declare(const char* name, const char* format, void* address);
  bool open(const char*, ConfigFile& params);
  bool log(Time);

 private:
  CannedDataWriter _writer;
  FormatParser* _parser;
  List<LogElem> _elems;
  unsigned char* _buffer;
  int _buffer_size;
};

__UTILS_END_NAMESPACE

#endif

