#ifndef UTILS_INTERFACE_H
#define UTILS_INTERFACE_H

#include <utils/Managed.h>

namespace utils {
    template <class T> class Generator;
    class SymbolTable;
    class ConfigFile;
};

#define UTILS_INTF_GEN(T) UTILS__CONCAT(T,Generator)
#define UTILS_INTERFACE(T) \
	class T; \
	/** Convenience typedef for reconfigurable instance generation */ \
	typedef utils::Generator<T> UTILS_INTF_GEN(T); \
	class T : public utils::Managed
#define UTILS_INTF_DECL(T) \
	/** Get the interface name */ \
	static const char* intfName() {return UTILS__QUOTE(T) "Intf";} \
	/** Create interface from string if not in symbol table already, put in symbol table afterwards under \p intfName()  */ \
	static T* create(const char*, utils::SymbolTable* globals=NULL); \
	/** Create interface from file if not in symbol table already, put in symbol table afterwards under \p intfName()  */ \
	static T* create(utils::ConfigFile&,utils::SymbolTable* globals=NULL);\
	/** Create interface from string if not in symbol table already */ \
	static T* interface(const char*, utils::SymbolTable* globals=NULL); \
	/** Create interface from string */ \
	static T* generate(const char*, utils::SymbolTable* globals=NULL); \
	/** Get the interface generator */ \
	static UTILS_INTF_GEN(T) *generator(utils::SymbolTable* globals); \
	/** Get the last result of \p create */ \
	static T* getIntf(utils::SymbolTable* globals); \
	/** Clear the interface out of the symbol table  */ \
	static void clear(utils::SymbolTable* globals); 

#endif
