/***************************************************************************

                                ConfigWatch.h

  Defines abstract base class for configuration element watchers, i.e.,
  callbacks which can be put in place for sections of configuration files

***************************************************************************/

#ifndef UTILS_CONFIG_WATCH_H
#define UTILS_CONFIG_WATCH_H

#include <utils/BaseSub.h>

__UTILS_BEGIN_NAMESPACE

class ConfigElem;
class StructElem;

class ConfigWatch : public Managed
{
  UTILS_BASE_ABSTRACT_HEADER(ConfigWatch);

 public:
  ConfigWatch();

  virtual void set(ConfigElem*) = 0;
  virtual void add(StructElem*, const char* name, ConfigElem*) = 0;

  static void initClass();
};

__UTILS_END_NAMESPACE

#endif

