#ifndef CANNEDDATAACCESS_H
#define CANNEDDATAACCESS_H

//#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include <utils/port.h>

__UTILS_BEGIN_NAMESPACE

#define CANNED_DATA_MAJOR_VERSION 1
#define CANNED_DATA_MINOR_VERSION 0

typedef enum {
	CDT_UNKNOWN    = 0,  
	CDT_TEST       = 1,
	CDT_VIDEO      = 2,
	CDT_SICK       = 3,
	CDT_INVALID    = 4   /* This should be the last type */
} CannedDataType;

class CannedDataTimeStamp
{
 private:
	uint64_t _absDiff(uint64_t val1, uint64_t val2) {
		if (val1 > val2) {
			return val1 - val2;
		}
		return val2 - val1;
	}
 public:
	CannedDataTimeStamp(uint64_t s = 0, uint64_t u = 0):secs(s),usecs(u) {};
	uint64_t secs;
	uint64_t usecs;
	void normalize() {
		if (usecs > 1000000) {
			secs += usecs / 1000000;
			usecs %= 1000000;
		}
	}
	
	int operator == (const CannedDataTimeStamp &rhs) const {
		return (secs == rhs.secs) && (usecs == rhs.usecs);
	}

	int operator < (const CannedDataTimeStamp &rhs) const  {
		if ((secs < rhs.secs) 
		    || ((secs == rhs.secs)
			&& (usecs < rhs.usecs))) {
			return 1;
		}
		return 0;
	}
	CannedDataTimeStamp absDiff(const CannedDataTimeStamp &rhs) {
		/* There's got to be a better way to do this */
		CannedDataTimeStamp retval(_absDiff(secs, rhs.secs), _absDiff(usecs, rhs.usecs));
		if (rhs < *this) {
			if (rhs.usecs > usecs) {
				retval.secs--;
				retval.usecs = (1000000 - retval.usecs); 
			}
		} else {
			if (rhs.usecs < usecs) {
				retval.secs--;
				retval.usecs = (1000000 - retval.usecs); 
			}
		}
		return retval;
	}
	
	void operator -= (const CannedDataTimeStamp &rhs) {
		if (!(rhs < (*this))) {
			printf("Egads!  " 
			       PF_64U " " PF_64U " > "
					PF_64U " " PF_64U "\n", 
			       (long long unsigned int)rhs.secs, 
			       (long long unsigned int)rhs.usecs, 
			       (long long unsigned int)secs, 
			       (long long unsigned int)usecs);
			exit(-1);
		}
		if (usecs < rhs.usecs) {
			usecs += 1000000;
			secs--;
		}
		usecs -= rhs.usecs;
		secs -= rhs.secs;
	}
	
	void operator += (const CannedDataTimeStamp &rhs) {
		usecs += rhs.usecs;
		secs += rhs.secs;
		normalize();
	}
};

class CannedDataIdxRecord {
 public:
	CannedDataIdxRecord() {};
	CannedDataTimeStamp time_stamp;
	uint32_t ofs;
	uint32_t size;
	uint8_t file_no;
};

typedef struct {
	uint32_t major;
	uint32_t minor;
} CannedDataVersionRecord;

__UTILS_END_NAMESPACE

#include <utils/CannedDataID.h>
#include <utils/CannedDataError.h>
#include <utils/CannedBase.h>
#include <utils/CannedDataIndex.h>
#include <utils/CannedDataRead.h>
#include <utils/CannedDataWrite.h>

#endif
