/***************************************************************************

                                BinPlayer.h

  Defines a class can be used to read values from a binary file 
  with tags and times.  It attempts to return the variables at the
  correct time.  

  Classes defined for export:
    BinPlayer - the playback class

***************************************************************************/

#ifndef UTILS_BIN_PLAYER_H
#define UTILS_BIN_PLAYER_H

#include <utils/StringDict.h>
#include <utils/Input.h>
#include <utils/Time.h>
#include <utils/Managed.h>

__UTILS_BEGIN_NAMESPACE

class Input;
class BinPlayerTag;
class ConfigFile;
class SymbolTable;

struct PlayVectorSpec {
  int max_size;
  int size;
  void* data;
};

class BinPlayer : public Managed {
public:
    BinPlayer();
    ~BinPlayer();

    void setZero(Time zero);

    bool expect(const char* tag, const char* name, const char* format,
                void* address);
    bool open(const char*);
    void close();
    bool get(const char* tag, Time& play_time);
    bool getPrevious(const char* tag, Time& play_time);
    bool next(const char* tag, Time& time);

    int getByteOrder() const { return _byte_order; }
    int getAlignment() const { return _alignment; }

    static BinPlayer* create(ConfigFile*, SymbolTable*);

private:
    bool read_line(Time& time);
    
private:
    Input _input;        // the input of the player
    bool _close_input;   // whether this class in charge of closing the input

    StringDict<BinPlayerTag*> _values;  // dictionary of tags 
    bool _read_time;  // true if we have read a logged time
    Time _offset;    // amount to substract from logged time
    Time _first_time; // first logged time
    Time _zero_time;  // time defined as zero (_offset=_zero_time-_first_time)
    int _byte_order, _alignment;
    bool _old_version;
};

__UTILS_END_NAMESPACE

#endif

