#ifndef utils_binlogger_h
#define utils_binlogger_h

#include <utils/Time.h>
#include <utils/Output.h>
#include <utils/Managed.h>

__UTILS_BEGIN_NAMESPACE

template <class T> class StringDict;
template <class T> class List;
class ConfigFile;
class SymbolTable;
class LoggingClass;
class LogElem;

struct LogVectorSpec {
  int size;
  void* data;
};

class BinLogger : public Managed {
 public:
  BinLogger();
  ~BinLogger();

  bool declare(const char* tag, const char* name, const char* format, 
               void* address);
  bool open(const char*);
  void commit();
  void close();
  bool log(const char* tag, Time);

  static BinLogger* create(ConfigFile*, SymbolTable*);

 private:
  StringDict<LoggingClass*>* _tags;
  Output _output;
  bool _close_output;
};

__UTILS_END_NAMESPACE

#endif
