#include <stdio.h>
#include <string.h>

#include <utils/ConfigFile.h>
#include <utils/StringDict.h>
#include <utils/Output.h>
#include <utils/SpecElem.h>

int main(int argc, char** argv) 
{
  __UTILS::ConfigFile config;
  __UTILS::StringDict<int> typenames;
  __UTILS::SpecElem::initClass();

  if (argc < 2) {
    printf("Syntax error: config_test [output] name number name number ...\n");
    exit(-1);
  }

  typenames.enter("int", config.intType().getKey());
  typenames.enter("float", config.floatType().getKey());
  typenames.enter("double", config.doubleType().getKey());
  typenames.enter("char", config.charType().getKey());
  typenames.enter("bool", config.boolType().getKey());
  typenames.enter("string", config.stringType().getKey());

  if (!config.open("test.conf")) {
    printf("Error parsing file\n");
    exit(-1);
  }

  int start = 1;
  bool outputting;
  if (!strcmp(argv[1], "output")) {
    outputting=true;
    start++;
  } else
    outputting=false;

  int j;
  unsigned char buffer[1000];
  for (int i = start; ; i+=3) {
    if (i+3 > argc+1)
      break;

    int key;
    if (typenames.find(argv[i], key)) {
      utils::Type type(key);
      int max_num = atoi(argv[i+2]);
      if (max_num < 1) {
        printf("'%s' not a valid number for %s, %s\n",
               argv[i+2], argv[i], argv[i+1]);
        continue;
      }
      int res = config.get(type, argv[i+1], buffer, max_num);
      if (res <= 0) {
        printf("Could not get %s, %s, %d\n",
               argv[i], argv[i+1], max_num);
        continue;
      }
      printf("%s %s: ", argv[i], argv[i+1]);
      if (type == config.intType()) {
        int* data = (int*) buffer;
        for (j=0;j<res;j++)
          printf("%d ", data[j]);
      } else if (type == config.floatType()) {
        float* data = (float*) buffer;
        for (j=0;j<res;j++)
          printf("%f ", data[j]);
      } else if (type == config.doubleType()) {
        double* data = (double*) buffer;
        for (j=0;j<res;j++)
          printf("%f ", data[j]);
      } else if (type == config.stringType()) {
        const char** data = (const char**) buffer;
        for (j=0;j<res;j++)
          printf("'%s' ", data[j]);
      } else if (type == config.charType()) {
        char* data = (char*) buffer;
        for (j=0;j<res;j++)
          printf("%c ", data[j]);
      } else if (type == config.boolType()) {
        bool* data = (bool*) buffer;
        for (j=0;j<res;j++)
          printf("%d ", (int) data[j]);
      }

      printf("\n");
    }
  }
  
  config.setInt("simple.new_int", 2);

  if (outputting) {
    printf("Original file: \n");
    __UTILS::Output output;
    output.setFilePointer(stdout);
    config.write(output);

    printf("\n\n\nAnd its copy\n");
    __UTILS::ConfigFile* other = __UTILS::ConfigFile::copy(&config);
    other->write(output);
    delete other;
  }
}                    
