#include <stdio.h>
#include <time.h>
#include <utils/CannedDataRead.h>
#include <utils/CannedDataWrite.h>
#include <utils/Time.h>

int main(int argc, char** argv)
{
  if (argc < 4) {
    printf("Usage:  %s <input name> <offset> <output name>\n", argv[0]);
    return -1;
  }
  try {
    utils::CannedDataReader reader;
    reader.open(argv[1]);
    utils::CannedDataWriter writer;
    writer.open(argv[3]);

    writer.writeType(reader.getType());
    uint32_t major, minor;
    reader.getVersion(&major, &minor);
    writer.writeVersion(major, minor);
    writer.writeDescription(reader.getDescription().getString());
    int max_size = reader.getHeaderSize();
    char* buffer = new char[max_size];
    int size = fread(buffer, 1, reader.getHeaderSize(), reader.getHeader());
    writer.writeHeader(buffer, size);

    reader.first();

    int nr = reader.getNumRecords();
    utils::Time offset_time(atof(argv[2]));
    for (int i=0;i<nr;i++) {
      size = reader.getRecordSize();
      if (size > max_size) {
        delete [] buffer;
        max_size = size;
        buffer = new char[max_size];
      }
      fread(buffer, 1, size, reader.getRecord());
      uint64_t secs, usecs;
      reader.getCurTimeStamp(&secs, &usecs);
      utils::Time tag(secs, usecs);
      tag += offset_time;
      long s, u;
      tag.getValue(s, u);
      writer.writeData(buffer, size, s, u);

      reader.next();
    }

  } catch (utils::CannedDataError err) {
    fprintf(stderr, "Ack: %s\n", err.getMsg().getString());
  }
}           
           

  


  
