#include <stdio.h>
#include <time.h>
#include <utils/CannedDataRead.h>
#include <utils/CannedDataWrite.h>
#include <utils/Time.h>

int main(int argc, char** argv)
{
  if (argc < 5) {
    printf("Usage:  %s <input name> <offset> <length> <output name>\n",
           argv[0]);
    return -1;
  }
  try {
    utils::CannedDataReader reader;
    reader.open(argv[1]);
    utils::CannedDataWriter writer;
    writer.open(argv[4]);

    writer.writeType(reader.getType());
    uint32_t major, minor;
    reader.getVersion(&major, &minor);
    writer.writeVersion(major, minor);
    writer.writeDescription(reader.getDescription().getString());
    int max_size = reader.getHeaderSize();
    char* buffer = new char[max_size];
    int size = fread(buffer, 1, reader.getHeaderSize(), reader.getHeader());
    writer.writeHeader(buffer, size);

    reader.first();

    int nr = reader.getNumRecords();
    utils::Time start_excise(atof(argv[2]));
    uint64_t secs, usecs;
    reader.getFirstTimeStamp(&secs, &usecs);
    start_excise += utils::Time(secs, usecs);
    utils::Time end_excise(atof(argv[3]));
    end_excise += start_excise;
    for (int i=0;i<nr;i++) {
      size = reader.getRecordSize();
      if (size > max_size) {
        delete [] buffer;
        max_size = size;
        buffer = new char[max_size];
      }
      fread(buffer, 1, size, reader.getRecord());
      uint64_t secs, usecs;
      reader.getCurTimeStamp(&secs, &usecs);
      utils::Time tag(secs, usecs);
      if (tag < start_excise || tag > end_excise)
        writer.writeData(buffer, size, secs, usecs);

      reader.next();
    }

  } catch (utils::CannedDataError err) {
    fprintf(stderr, "Ack: %s\n", err.getMsg().getString());
  }
}           
           

  


  
