#include <stdio.h>
#include <time.h>
#include <utils/CannedDataRead.h>
#include <utils/Time.h>

int main(int argc, char** argv)
{
  if (argc < 2) {
    printf("Usage:  %s <canned data name>\n", argv[0]);
    return -1;
  }
  try {
    utils::CannedDataReader reader;
    reader.open(argv[1]);

    printf("Canned data file %s:\n", argv[1]);
    printf("\tDescription: %s\n", reader.getDescription().getString());
    time_t t = reader.getCreationTime();
    printf("\tCreated on %s", ctime(&t));
    uint64_t secs, usecs;
    reader.getFirstTimeStamp(&secs, &usecs);
    t = secs;
    char time_buf[300];
    strftime(time_buf, 300, "%b %d %G %H:%M:%S", localtime(&t));
    printf("\tExtends from %s.%03d", time_buf, (int) (usecs/1000));
    utils::Time start(secs, usecs);
    reader.getLastTimeStamp(&secs, &usecs);
    utils::Time last(secs, usecs);
    printf(" for %f seconds\n", (last-start).getValue());
    printf("\t%d Records (first is %d bytes long)\n", reader.getNumRecords(),
           (int) reader.getRecordSize());

    char* buffer = new char[reader.getHeaderSize()+1];
    int size = fread(buffer, 1, reader.getHeaderSize(), reader.getHeader());
    buffer[size] = '\0';
    printf("\tHeader length %d bytes, header is, \n------\n%s\n------\n",
           (int) reader.getHeaderSize(), buffer);
    delete [] buffer;
  } catch (utils::CannedDataError err) {
    fprintf(stderr, "Ack: %s\n", err.getMsg().getString());
    return -1;
  }
  return 0;
}           
           

  


  
