/***************************************************************************

                                cStringDict.cc

  Implements C cover functions to give C programmers access to the StringDict
  functionality.  See StringDict.cc for more documentation on each
  function

  C Cover functions implemented for the equivalent StringDict methods:
    SDICT_new, SDICT_delete, SDICT_applyToAll, SDICT_clear, SDICT_enter
    SDICT_find, SDICT_remove

***************************************************************************/
#include <utils/StringDict.h>

extern "C" {

UTL_StringDict SDICT_new(int num_buckets)
{
    return new __UTILS::BasicStringDict(num_buckets);
}

void SDICT_delete(UTL_StringDict dict)
{
    delete dict;
}

void SDICT_applyToAll(UTL_StringDict dict, SDICT_CallbackFunc func, void* data)
{
    dict->applyToAll(func, data);
}

void SDICT_clear(UTL_StringDict dict)
{
    dict->clear();
}

bool SDICT_enter(UTL_StringDict sd, const char* key, void* value)
{
    return sd->enter(key, value);
}
    
bool SDICT_find(UTL_StringDict sd, const char* key, void** value)
{
    return sd->find(key, *value);
}

bool SDICT_remove(UTL_StringDict sd, const char* key)
{
    return sd->remove(key);
}

}

