#include <stdio.h>
#include <unistd.h>

#include <utils/BinPlayer.h>

int main()
{
  __UTILS::BinPlayer player;

  __UTILS::PlayVectorSpec vec;
  float logvals[10];
  vec.max_size = 9;
  vec.data = logvals;

  player.expect("VEC", "vec", "Vector: format=Float;", &vec);

  if (!player.open("test.log")) {
    printf("Could not open test.log for playing\n");
    exit(-1);
  }

  __UTILS::Time log_time;
  long sec, usec;
  while (player.next("VEC", log_time)) {
    log_time.getValue(sec, usec);
    printf("%ld %ld: %d", sec, usec, vec.size);
    for (int i=0;i<vec.size;i++)
      printf(" %f", logvals[i]);
    printf("\n");
  }
}
    
