#include <math.h>
#include <unistd.h>
#include <string.h>

#include <utils/BinLogger.h>
#include <utils/Time.h>

int main()
{
  float logvals[10];
  __UTILS::LogVectorSpec vector;
  __UTILS::BinLogger logger;

  vector.data = logvals;

  memset(logvals, 0, sizeof(logvals));

  logger.declare("VEC", "vec", "Vector: format=Float;", &vector);
  logger.open("test.log");
  logger.commit();

  __UTILS::Time now;
  long sec, usec;
  for (int i=0;i<10;i++) {
    vector.size = i+1;
    for (double th=M_PI; th>-M_PI; th = th-0.05) {
      logvals[i] = th;
      now = __UTILS::Time::getTimeOfDay();
      logger.log("VEC", now);
      now.getValue(sec, usec);
      printf("%ld %ld: %d", sec, usec, vector.size);
      for (int j=0;j<vector.size;j++)
        printf(" %f", logvals[j]);
      printf("\n");
      utils::Time::sleep(0.001);
    }
  }
}

