#include <math.h>
#include <unistd.h>
#include <string.h>

#include <utils/BinLogger.h>
#include <utils/Time.h>

int main()
{
    float logvals[3];
    __UTILS::BinLogger logger;

    memset(logvals, 0, sizeof(logvals));

    logger.declare("TEST", "sth", "Float", &logvals[0]);
    logger.declare("TEST", "cth", "Float", &logvals[1]);
    logger.declare("TEST", "th", "Angle", &logvals[2]);
    logger.declare("ARRAY", "all",
                   "Array: size=3; spec format {Float: interpolate=false;}",
                   logvals);
      
    logger.open("test.log");
    logger.commit();

    __UTILS::Time now;
    for (int i=0;i<10;i++) 
      for (double th=M_PI; th>-M_PI; th = th-0.05) {
        logvals[0] = sin(th);
        logvals[1] = cos(th);
        logvals[2] = th;
        now = __UTILS::Time::getTimeOfDay();
        logger.log("TEST", now);
        logger.log("ARRAY", now);
        utils::Time::sleep(0.001);
      }
}



        

        
    
