#include <utils/Vec3d.h>

__UTILS_BEGIN_NAMESPACE

InvalidIndexException Vec3d::iie;

void Vec3d::rotateZ(double theta) {
  double tmp[3] = {v[0],v[1],v[2]};
  v[0] = cos(theta)*tmp[0] + sin(theta)*tmp[1];
  v[1] = -sin(theta)*tmp[0] + cos(theta)*tmp[1];
}

Vec3d::Vec3d(double p0,double p1, double p2) {
  v[0]=p0;
  v[1]=p1;
  v[2]=p2;
}

double Vec3d::length(void) {
  return sqrt(v[0]*v[0]+v[1]*v[1] + v[2]*v[2]);
}


Vec3d Vec3d::normalize(void) {
  double l =length();
  if (l==0) 
    return *this;
  v[0]/=l;
  v[1]/=l;
  v[2]/=l;
  return *this;
  
}

void Vec3d::clip(Vec3d & clipper) {
    if (v[0]>clipper[0])
	v[0]=clipper[0];
    if (v[1]>clipper[1])
	v[1]=clipper[1];
    if (v[2]>clipper[2])
	v[2]=clipper[2];
}

void Vec3d::clipabs(Vec3d &clipper) {
    if (fabs(v[0])>fabs(clipper[0]))
	v[0]=SGN(v[0])*fabs(clipper[0]);
    if (fabs(v[1])>fabs(clipper[1]))
	v[1]=SGN(v[1])*fabs(clipper[1]);
    if (fabs(v[2])>fabs(clipper[2]))
	v[2]=SGN(v[2])*fabs(clipper[2]);
}  


std::ostream &operator<<(std::ostream &str, Vec3d const &v) {
  str << "[" << v.v[0] << " ,"  << v.v[1] << " ," << v.v[2] << "]";
  return str;
}

std::istream &operator>>(std::istream &s, Vec3d &in) {
  char c = 0;
  s >> c;
  if (c!='[') {
    s.clear(std::ios::badbit);
    return s;
  }
  s >> in[0];
  s >> c;
  if (c!=',') {
    s.clear(std::ios::badbit);
    return s;
  }
  s >> in[1];
  s >> c;
  if (c!=',') {
    s.clear(std::ios::badbit);
    return s;
  }
  s >> in[2];
  s >> c;
  if (c!=']') {
    s.clear(std::ios::badbit);
    return s;
  }
  return s;

}

Vec3d & Vec3d::operator +=(const Vec3d& rhs) {
  v[0]+=rhs[0];
  v[1]+=rhs[1];
  v[2]+=rhs[2];
  return *this;
}

Vec3d & Vec3d::operator -=(const Vec3d& rhs) {
  v[0]-=rhs[0];
  v[1]-=rhs[1];
  v[2]-=rhs[2];
  return *this;
}

Vec3d& Vec3d::operator=(const Vec3d rhs) {
  if (this ==&rhs) return *this;
  v[0]=rhs[0];
  v[1]=rhs[1];
  v[2]=rhs[2];
  return *this;
}

Vec3d& Vec3d::operator=(const double rhs) {
  v[0]=rhs;
  v[1]=rhs;
  v[2]=rhs;
  return *this;
}

double  Vec3d::dot(const Vec3d& on) const{
  double ret;
  ret = on[0]*v[0] +on[1]*v[1] + on[2]*v[2] ;
  return ret;
}

/**
      * Returns the angle in radians between this vector and
      * the vector parameter; the return value is constrained to the
      * range [0,PI].
      * @param v1  the other vector
      * @return the angle in radians in the range [0,PI]
      */
 double Vec3d::angle(const Vec3d &v1) const {
        // return (double)Math.acos(dot(v1)/v1.length()/v.length());
        // Numerically, near 0 and PI are very bad condition for acos.
        // In 3-space, |atan2(sin,cos)| is much stable.
        Vec3d c;
	
	
        c= cross( v1);
        double sin = c.length();

        return fabs(atan2(sin ,dot(v1)));
    }

__UTILS_END_NAMESPACE


