/***************************************************************************

                                Mutex.cc

  Provides a place to hold the Mutex_Factory, a global which is set with 
  a routine which can create Mutex's.  When it is set, many of the other
  utils library use it to protect their global data to make the utils library
  threadsafe.

  Globales implemented for export
    Mutex_Factory

***************************************************************************/

#include <utils/Mutex.h>
#include <stdlib.h>

#ifdef HAVE_PTHREAD_H

#include <pthread.h>

__UTILS_BEGIN_NAMESPACE

class PosixMutex : public Mutex {
public:
  PosixMutex() {
    pthread_mutex_init(&_mutex, NULL);
  }
        
  virtual bool lock() {
    pthread_mutex_lock(&_mutex);
    return true;
  }

  virtual bool unlock() {
    pthread_mutex_unlock(&_mutex);
    return true;
  }

private:
  pthread_mutex_t _mutex;
};
        
        
static Mutex* create_standard_mutex()
{
  return new PosixMutex();
}

#else
__UTILS_BEGIN_NAMESPACE

#define create_standard_mutex NULL;
#endif

MutexCreator Mutex_Factory = create_standard_mutex;

__UTILS_END_NAMESPACE

