#include <utils/CannedDataAccess.h>

__UTILS_BEGIN_NAMESPACE

CannedDataIndex::CannedDataIndex ()
{
	_cur = 0;
}

CannedDataIndex::~CannedDataIndex()
{
}

void CannedDataIndex::first   ()
{
	_cur = 0;
	if (_data.empty()) {
		throw CannedDataError("Attempt to grab first element of an empty index");
	}
	_cur = 0;
}

void CannedDataIndex::last    ()
{
	if (_data.empty()) {
		throw CannedDataError("Attempt to grab last element of an empty index");
	}
	_cur = _data.numElems() - 1;
}

void CannedDataIndex::next    ()
{
	if (_data.empty()) {
		throw CannedDataError("Attempt to grab next element of an empty index");
	}
	if (int(_cur) != (_data.numElems() - 1)) {
		_cur++;
	}
}

void CannedDataIndex::previous()
{
	if (_data.empty()) {
		throw CannedDataError("Attempt to grab previous element of an empty index");
	}
	if (_cur) {
		_cur--;
	}
}

CannedDataIdxRecord CannedDataIndex::current ()
{
	if (_data.empty()) {
		throw CannedDataError("Attempt to grab previous element of an empty index");
	}
	return _data[_cur];
}

int CannedDataIndex::seekBefore    (uint64_t secs, uint64_t usecs)
{
	CannedDataTimeStamp tmp(secs, usecs);
	unsigned int top, bottom, split;

	if (tmp < _data[0].time_stamp) {
		return -1;
	}

	top = _data.numElems();
	bottom = 0;
	split = bottom + (top - bottom)/2;
	while (split != bottom) {
		if (tmp < _data[split].time_stamp) {
			top = split;
		} else {
			bottom = split;
		}
		split = bottom + (top - bottom)/2;
	}
	_cur = split;
	return 0;
}

void CannedDataIndex::seek    (uint64_t secs, uint64_t usecs)
{
	CannedDataTimeStamp tmp(secs, usecs);
	if (seekBefore(secs, usecs)) {
		_cur = 0;
	} else {
		/* We're not quite done; The closest value could be this one, or the next one higher */
		/* Note this '-' operator is an *absolute* difference */
		if (!((int(_cur) == (_data.numElems() - 1))
		      || ((_data[_cur].time_stamp.absDiff(tmp)) < (_data[_cur + 1].time_stamp.absDiff(tmp))))) {
			_cur++;
		}
	}
}


void CannedDataIndex::add     (const CannedDataIdxRecord &data) 
{
	if (!_data.empty()
	     && (data.time_stamp < _data.last().time_stamp)) {
                fprintf(stderr, "Warning:  data file has records out of order.  Skipping out of order elements\n");
                return;
//		throw CannedDataError("Attempt to add an element out of order!\n");
	}
	_data.append(data);
}

int CannedDataIndex::atEnd   ()
{
	return (int(_cur) == (_data.numElems() - 1));
}

int CannedDataIndex::atStart   ()
{
	return (_cur == 0);
}

int CannedDataIndex::size    ()
{
	return _data.numElems();
}

int CannedDataIndex::getPos   ()
{
	return _cur;
}

void CannedDataIndex::setPos  (int pos)
{
	_cur = pos;
}

__UTILS_END_NAMESPACE
