#include <utils/CannedDataError.h>
#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>
#include <utils/port.h>

__UTILS_BEGIN_NAMESPACE

CannedDataError::CannedDataError(char *fmt, ...)
{
	va_list ap;
	size_t len;
	char *tmp;

	/* This doesn't actually do anything other than see how long the string will be, according
	 * to the C99 spec.  Care should be taken if this is ported, though...
	 */
	va_start(ap, fmt);
	len = vsnprintf(0, 0, fmt, ap);
	va_end(ap);
	tmp = (char *)malloc(len + 1); 
	if (tmp) {
		va_start(ap, fmt);
		vsnprintf(tmp, len+1, fmt, ap);
		va_end(ap);
	}
	errMsg = tmp;
        free((void*) tmp);
}

CannedDataError::~CannedDataError()
{
}

const String &CannedDataError::getMsg() 
{
	return errMsg;
}

__UTILS_END_NAMESPACE

