/***************************************************************************

                                Base.cc
  
 Defines the Base class for run time typed classes.  Base is a subclass of
 Managed, so we get reference counting as well.  Helper macros for defining
 subclasses of Base are in utils/BaseSub.h

 Before Base can be used, Name::initClass must be called or mysterious bad 
 things happen.

 Note:  In the future could we replace this with gcc RTTI stuff?

***************************************************************************/

#include <utils/Base.h>

__UTILS_BEGIN_NAMESPACE

short Base::_class_type_id = 0;

// Base's initializion class
class BaseInitializer { 
  public: 
    BaseInitializer() { Base::initClass(); } 
};

// virtual destructor to keep g++ happy
Base::~Base()
{
}

// return the class type ID
Type Base::getTypeId() const                                       
{                                                                         
    return Type(_class_type_id);
}

// get the type name
const char* Base::getTypeName() const
{
    return getTypeId().getName().getString();
}

// return true if this object is decended from type
bool Base::isOfType(Type type) const 
{
    return getTypeId().isDerivedFrom(type);
}

// return true if this object is of type type
bool Base::isType(Type type) const
{
    return getTypeId() == type;
}

// create a Base
Base::Base()
{
    // the static initializer is a C++ trick to ensure that the initClass
    // routine for Base is called before the first Base is created
    static BaseInitializer initializer;
}

// initialize the Base class
void Base::initClass()
{
    if (_class_type_id)
        return;
    _class_type_id = (short) Type::createType(Type(), "Base").getKey();
}

__UTILS_END_NAMESPACE

