/* $Revision: 1.1 $

$Date: 2004/07/24 17:55:08 $

$Author: jayg $*/
/** @file libsort_c.cc

PROJECT: Grand Challenge
AUTHOR: Chris Urmson (curmson@ri.cmu.edu)
DESCRIPTION:

*/
/*REVISION HISTORY

$Log: libsort_c.cc,v $
Revision 1.1  2004/07/24 17:55:08  jayg
Added handy dandy new makefile stuff from red team

Revision 1.1  2004/02/15 22:58:29  curmson
Change to use a c version of libsort to speed up linking


(c) Copyright 2004 CMU. All rights reserved.
*/
#ifndef LIBSORT_C_CC
#define LIBSORT_C_CC
#include <vector>
#include <iostream>
//#include <fstream>
#include <list>
#include <string.h>

using namespace std;

struct CompilerFlag {
  char flag[100];
  int index;
};
  

/*sorts a list of -Lxxx and -lxxx
  puts all -Lxxx at the beginning and keeps only the last -lxxxx*/

#define BUFFER_SIZE 100000
int main(void) {
  const char *delim = " \t\n\r";
  char buffer[BUFFER_SIZE];
  vector<CompilerFlag> dirs, libs;
  list<CompilerFlag> output;
  CompilerFlag cf;
  int index=0;
  int i, j;
  char *flag;

//  ofstream logger("dump.txt");

  cin.getline(buffer,BUFFER_SIZE);
//  logger << "input: '" << buffer << "'" << endl;;
  
  flag = strtok(buffer,delim);
  while (flag) {
    strncpy(cf.flag,flag,100);
    cf.index = index++;
    if (cf.flag[1]=='L') {
      //we've got a directory
      dirs.push_back(cf);
    } else {
      libs.push_back(cf);
    }
    flag = strtok(NULL,delim);
  }


  bool already_output=false;





  // we've now got our libs and dirs, time to sort them- dump them out
  for (i=libs.size()-1;i>-1;i--) {
    already_output=false;
    // sweep through what we've already printed, if it's there don't output.
    for (j=i+1;j<libs.size();j++) {
      if (!strcmp(libs[i].flag,libs[j].flag)) {
	already_output=true;
	break;
      }
    }

    // if already_output, then we don't do anything
    if (!already_output) {
      output.push_front(libs[i]);
    } else {
      // we don't output it...
    }
  } // for i;


  // do the same exact thing for the dirs
  for (i=dirs.size()-1;i>-1;i--) {
    already_output=false;
    // sweep through what we've already printed, if it's there don't output.
    for (j=i+1;j<dirs.size();j++) {
      if (!strcmp(dirs[i].flag,dirs[j].flag)) {
	already_output=true;
	break;
      }
    }
    // if already_output, then we don't do anything
    if (!already_output) {
      output.push_front(dirs[i]);
    } else {
      // we don't output it...
    }
    
  } // for i;



//  logger << "output: '";
  list<CompilerFlag>::iterator it;
  for (it = output.begin();it!=output.end();it++) {
    cout << it->flag << " ";
//    logger << it->flag << " ";
  }

//  logger << "'" << endl;

}





#endif //ifndef LIBSORT_C_CC
