include $(UTILS_DIR)/include/$(PLATFORM)/UtilsFlags.mk

INCLUDE_FLAGS := $(EXTRA_INCLUDES) \
	 -I$(INSTALL_DIR)/include -I$(UTILS_DIR)/include
OPT_FLAGS = -g -Wall 
DEF_FLAGS = $(EXTRA_DEFS)
CPPFLAGS = $(INCLUDE_FLAGS) $(DEF_FLAGS)
CXXFLAGS = $(OPT_FLAGS)
DEPFLAGS = $(OPT_FLAGS) $(DEF_FLAGS)
INST_TARGET ?= $(TARGET)

LIBS = $(UTILS_LIB_FLAGS)  $(EXTRA_LIBS) $(LOCAL_LIBS) \
	$(INTF_LIBS) $(UTILS_LIBS)

OBJS = $(foreach file,$(FILES), $(file).o)
MODOBJS = $(OBJS) $(foreach file,$(MODFILES), $(file).o)
SRCS = $(foreach file,$(FILES), $(file).cc) \
	$(foreach file,$(MODFILES), $(file).cc) $(EXTRA_SRCS)

$(TARGET): $(MODOBJS) $(LOCAL_LIBS) $(LIB_DEPENDS)
	$(CXX) $(OPT_FLAGS) -o $(TARGET) $(MODOBJS) $(LIBS)

%.d: %.cc 
	$(SHELL) -ec '$(CXX) -M $(CPPFLAGS) $< \
	              | sed '\''s/\($*\.o\)[ :]*/\1 $@ : /g'\'' > $@ '

$(INSTALL_DIR)/bin/$(INST_TARGET): $(TARGET)
	$(INSTALL_PROGRAM) $(TARGET) $(INSTALL_DIR)/bin/$(INST_TARGET)

install: all $(INSTALL_DIR)/bin/$(INST_TARGET) $(EXTRA_INSTALLS)

clean:
	rm -f $(TARGET) *.o *.d *~ core* *.pgm *# *.csv

%.d: %.cc
	@echo Generating dependencies for $< 
	@$(SHELL) -ec '$(CXX) -M $(CPPFLAGS) $< \
	              | sed '\''s/\($*\.o\)[ :]*/\1 $@ : /g'\'' > $@ '

include $(SRCS:.cc=.d)
