#ifndef INTF_TIME_SOURCE
#define INTF_TIME_SOURCE

#include <utils/Interface.h>
#include <utils/Time.h>

namespace utils {
  class Player;
  class ConfigFile;
  class SymbolTable;
};

UTILS_INTERFACE(TimeSource) {
 public:
  TimeSource();
  virtual ~TimeSource();

  virtual bool getTime(utils::Time&) = 0;
  virtual int getKey() = 0;
  virtual bool setTime(const utils::Time&, int key) = 0;
  virtual void setExtent(const utils::Time& beginning,
                         const utils::Time& ending) {}
  virtual bool getExtent(utils::Time& beginning,
                         utils::Time& ending) { return false; }
  virtual bool setScale(double scale, int key) { return false; }
  virtual bool advanceTime(double sleep_time) = 0;

  // static convenience functions
  static utils::Time now();
  static int getSettingKey();
  static bool setCurTime(const utils::Time&, int key);
  static void setDefaultTimeSource(TimeSource*);
  static TimeSource* getDefaultTimeSource();
  static void extent(const utils::Time& beginning,
                     const utils::Time& ending);

  UTILS_INTF_DECL(TimeSource);

 public:
  class PlayerManager {
  public:
    PlayerManager();
    ~PlayerManager();
    bool open(const char* default_name,
              utils::ConfigFile& params, utils::SymbolTable* table);
    bool next(utils::Time& time);
    bool poll();

    utils::Player* getPlayer() const { return _player; }

  private:
    utils::Time _last_time;
    bool _real_time, _external_time;
    TimeSource* _time_source;
    int _key;
    utils::Player* _player;
  };
};

#endif
