#ifndef INTF_TIME_SOURCE_SHMEM_H
#define INTF_TIME_SOURCE_SHMEM_H

#include <TimeSource/TimeSource.h>

class IPSharedMemory;

class ShmemTimeSource : public TimeSource {
 public:
  ShmemTimeSource(IPSharedMemory*);
  virtual ~ShmemTimeSource() {}

  virtual bool getTime(utils::Time&);
  virtual int getKey();
  virtual bool setTime(const utils::Time&, int key);
  virtual bool advanceTime(double step_time);

 private:
  IPSharedMemory* _shm;
};

class ShmemPublishTimeSource : public TimeSource {
 public:
  ShmemPublishTimeSource(TimeSource*, IPSharedMemory*);
  virtual ~ShmemPublishTimeSource();

  virtual bool getTime(utils::Time&);
  virtual int getKey();
  virtual bool setTime(const utils::Time&, int key);
  virtual void setExtent(const utils::Time& beginning,
                         const utils::Time& ending);
  virtual bool getExtent(utils::Time& beginning, utils::Time& ending);
  virtual bool advanceTime(double step_time);

 private:
  TimeSource* _contained;
  IPSharedMemory* _shm;
};

#endif
