#ifndef INTF_TIME_SOURCE_GUI_H
#define INTF_TIME_SOURCE_GUI_H

#include <pthread.h>

#include <utils/Time.h>
#include <TimeSource/Utils.h>

class TimeSourceIntf;

class GUITimeSource : public UtilsTimeSource {
 public:
  GUITimeSource(bool continuous, float scale, float nudge, float step,
                float offset, bool process);
  virtual void setExtent(const utils::Time& beginning,
                         const utils::Time& ending);
  virtual bool getExtent(utils::Time& beginning, utils::Time& ending);
  virtual bool getTime(utils::Time&);
  virtual bool setScale(double scale, int key);

  void setPercentage(double percentage);
  void setSlider(const utils::Time&);
  void setContinuous(bool);
  void pause();
  void deltaTime(float delta);
  void setScale(float scale);

 private:
  void output_time(const utils::Time&);

 private:
  float _offset;
  TimeSourceIntf* _intf;
  utils::Time _beginning;
  utils::Time _ending;
  bool _paused;
  char _end_buf[50];
  pthread_t _self;
  bool _process;
};

#endif
