#ifndef FILE_IMG_DISPLAY_H
#define FILE_IMG_DISPLAY_H

#include <utils/String.h>
#include <ImgDisplay/BufferDisplay.h>

class FileWindow;
class FileDisplay : public BufferDisplay {
 public:
  FileDisplay(const char** names, const char* dest_fmt);
  virtual ~FileDisplay();

  virtual ImgDisplay::Window*
  createWindow(const char* title, int width, int height,
               ImgDisplay::ColorType);
  virtual void destroyWindow(Window* win);
  virtual void destroyAllWindows();
  virtual ImgDisplay::ColorType defaultWindowColorType() const {
    return _dest_type;
  }

  virtual FileWindow* newFileWindow(int width, int height,
                                    ImgDisplay::ColorType src,
                                    ImgDisplay::ColorType dest);
  int numWins() const { return _num_wins; }
  const char* getCurrentName() const;

private:
  char** _names;
  int _num_names;
  int _num_wins;
  ColorType _dest_type;
};

class FileWindow : public BufferWindow
{
 public:
  FileWindow(const char* base_name, ImgDisplay* display, int width, int height,
             ImgDisplay::ColorType src_type, 
             ImgDisplay::ColorType dest_type);
  virtual ~FileWindow() {
    delete [] _data;
  }

  virtual bool begin();
  virtual void end();

  virtual bool writeFile();
  int fileNumber() const { return _file_number; }
  const char* fileName() const { return _file_name.getString(); }
  unsigned char* data() const { return _data; }
  bool isColor() const { return _color; }

private:
  unsigned char* _data;
  int _file_number;
  bool _color;
  utils::String _file_name;
};

#endif
