#ifndef INTF_REMOTE_CONFIG_SOURCE
#define INTF_REMOTE_CONFIG_SOURCE

#include <ConfigSource/Active.h>

class IPCommunicator;
class IPConnection;
class IPMessage;

class RemoteConfigSource : public ActiveConfigSource
{
 public:
  RemoteConfigSource(IPCommunicator* comm, IPConnection* source, const char*);
  virtual ~RemoteConfigSource();

  virtual bool attach(utils::Type type, const char* name,
                      void* data, int max_num=1,
                      ConfigCallback notify=NULL, void* cb_data=NULL,
                      void* default_data=NULL, int num_defaults=1);
  virtual bool processEvents(double timeout=-1.0);
  virtual bool refresh();

  bool valid() const { return _name != NULL; }
  bool initialize();

 private:
  void handle_set(IPMessage* msg);

 private:
  IPCommunicator* _communicator;
  IPConnection* _source;
  const char* _name;
};

#define GET_CONFIGURATION_MSG "GET_CONFIGURATION_MSG"
#define GET_CONFIGURATION_FMT "string"

#define CONFIGURATION_MSG "CONFIGURATION_MSG"
#define CONFIGURATION_FMT "string"

struct ConfigVarSpecStruct {
    const char* config_name;
    const char* var_name;
};

#define ATTACH_CONFIG_VAR_MSG "ATTACH_CONFIG_VAR_MSG"
#define ATTACH_CONFIG_VAR_FMT "{ string, string }"

#define CONFIG_VAR_ATTACHED_MSG "CONFIG_VAR_ATTACHED_MSG"
#define CONFIG_VAR_ATTACHED_FMT "int"

#define DETACH_CONFIG_VAR_MSG "DETACH_CONFIG_VAR_MSG"
#define DETACH_CONFIG_VAR_FMT "{ string, string }"

#define CONFIG_VAR_DETACHED_MSG "CONFIG_VAR_DETACHED_MSG"
#define CONFIG_VAR_DETACHED_FMT "int"

struct ConfigVarSetStruct {
    const char* var_name;
    const char* value;
};

#define CONFIG_VAR_SET_MSG "CONFIG_VAR_SET_MSG"
#define CONFIG_VAR_SET_FMT "{ string, string}"

#endif
