#ifndef INTF_FILE_CONFIG_SOURCE
#define INTF_FILE_CONFIG_SOURCE

#include <utils/ConfigFile.h>

#include <ConfigSource/ConfigSource.h>

class FileConfigSource : public ConfigSource
{
 public:
  bool open(const char* name);
  bool parse(const char* file);

  virtual int get(utils::Type type, const char* name,
                  void* data, int max_num=1,
                  void* default_data=NULL, int num_defaults=1);
  virtual bool attach(utils::Type type, const char* name,
                      void* data, int max_num=1,
                      ConfigCallback notify=NULL, void* cb_data = NULL,
                      void* default_data=NULL, int num_defaults=1);
  virtual bool set(const char* name, const char* value);
  virtual bool set(utils::Type, const char* name, void* data, int num_values);
  virtual bool processEvents(double timeout=-1.0);
  virtual int numValues(const char* name);
  virtual bool refresh();

  utils::ConfigFile& getFile() { return _file; }
  const char* getName() const { return _name.getString(); }

 protected:
  utils::ConfigFile _file;
  utils::String _name;
};    

#endif
