#include <stdio.h>
#include <unistd.h>

#include <utils/SymbolTable.h>
#include <utils/Time.h>

#include <TimeSource/TimeSource.h>

int main(int argc, char** argv)
{
    if (argc < 2)
        return -1;

    utils::SymbolTable* globals = new utils::SymbolTable;
    char buffer[200];
    snprintf(buffer, 200, "VehTester%d", getpid());
    globals->set("ModuleName", buffer);

    TimeSource* time_source = TimeSource::create(argv[1], globals);
    if (!time_source) {
      printf("'%s' is invalid time specification\n", argv[1]);
      exit(-1);
    }
    TimeSource::setDefaultTimeSource(time_source);
    utils::Time cur_time = TimeSource::now();
    TimeSource::extent(cur_time - utils::Time(25), cur_time + utils::Time(25));
    
    long secs, usecs;
    while (1) {
      cur_time = TimeSource::now();
      cur_time.getValue(secs, usecs);
      printf("%ld %ld\n", secs, usecs);
      utils::Time::sleep(0.1);
    }

    delete globals;
}
