#include <stdio.h>

#include <utils/SymbolTable.h>
#include <utils/Time.h>

#include <ConfigSource/ConfigSource.h>
#include <TimeSource/TimeSource.h>

#include <ipt/ipt.h>
#include <ipt/sharedmem.h>

int main(int argc, char** argv)
{
  const char* config_spec;
  if (argc < 2)
    config_spec = "active: name=time_driver.cfg";
  else
    config_spec = argv[1];

  utils::SymbolTable* globals = new utils::SymbolTable;
  globals->set("ModuleName", "TimeDriver");

  ConfigSource* config_src = ConfigSource::create(config_spec, globals);
  if (!config_src) {
    fprintf(stderr, "Invalid configuration source '%s'\n");
    exit(-1);
  }

  TimeSource* source = TimeSource::create("shmemdriver", globals);
  if (!source) {
    printf("Could not create time source\n");
    exit(-1);
  }
  int key = source->getKey();
  
  double start = config_src->getDouble("start", 0.0);
  double increment = config_src->getDouble("increment", 0.01);

  utils::Time start_time(start);
  utils::Time inc(increment);

  bool running;
  config_src->attachBool("running", &running, true);
  bool paused;
  config_src->attachBool("paused", &paused, false);
  utils::Time real_start = utils::Time::getTimeOfDay();
  utils::Time real;
  utils::Time time;

  while (running) {
    while (paused) 
      config_src->processEvents();

    real = utils::Time::getTimeOfDay();
    time = real-real_start + start_time;
    source->setTime(time, key);

    config_src->processEvents(increment);
    time += inc;
  }

  delete globals;
}
  
