#include <TimeSource/Utils.h>

#include <utils/ConfigFile.h>

TimeSource* create_TimeSource_utils(TimeSourceGenerator*,
                                    utils::ConfigFile* params,
                                    utils::SymbolTable*)
{
  return new UtilsTimeSource(params->getBool("continuous", true),
                             params->getFloat("scale", 1.0),
                             params->getFloat("step", 0.1));
}

UtilsTimeSource::UtilsTimeSource(bool continuous, float scale, float step)
{
  if (continuous) {
    utils::Time::useContinuousTime();
    utils::Time::setTimeConstant(scale);
  } else {
    utils::Time::useDiscreteTime();
    utils::Time::setTimeStep(step);
  }
}

bool UtilsTimeSource::getTime(utils::Time& t)
{
  t = utils::Time::getTimeOfDay() + _offset;
  
  return true;
}

int UtilsTimeSource::getKey()
{
  utils::Time t = utils::Time::getRealTimeOfDay();
  long sec, usec;
  t.getValue(sec, usec);

  _cur_key = usec;
  return _cur_key;
}

bool UtilsTimeSource::setTime(const utils::Time& t, int key)
{
  if (key != _cur_key)
    return false;

  setTime(t);

  return true;
}

bool UtilsTimeSource::setScale(double scale, int key)
{
  if (key != _cur_key)
    return false;

  utils::Time::useContinuousTime();
  utils::Time::setTimeConstant(scale);

  return true;
}

void UtilsTimeSource::setTime(const utils::Time& t)
{
  utils::Time now = utils::Time::getTimeOfDay();
  _offset = t - now;
}

bool UtilsTimeSource::advanceTime(double sleep_time)
{
  if (sleep_time <= 0)
    return false;

  if (utils::Time::getTimeMode() == 0) {
    utils::Time::sleep(sleep_time);
  } else {
    utils::Time now;
    getTime(now);
    setTime(now + utils::Time(sleep_time));
  }
  return true;
}
