#include <stdio.h>
#include <TimeSource/Sim.h>

#include <utils/ConfigFile.h>

TimeSource* create_TimeSource_sim(TimeSourceGenerator*,
                                  utils::ConfigFile* params,
                                  utils::SymbolTable*)
{
  return new SimTimeSource(params->getBool("continuous", true),
                           params->getFloat("scale", 1.0),
                           params->getFloat("step", 0.1),
                           params->getFloat("offset", 0.0));

}

SimTimeSource::SimTimeSource(bool continuous, float scale, float step,
                             float offset)
  : UtilsTimeSource(continuous, scale, step)
{
  _key = getKey();
  _offset = offset;
}

void SimTimeSource::setExtent(const utils::Time& beginning,
                              const utils::Time& ending)
{
  setTime(beginning + utils::Time(_offset), _key);
  _beginning = beginning;
  _ending = ending;
}

bool SimTimeSource::getExtent(utils::Time& beginning, utils::Time& ending)
{
  ending = _ending;
  beginning = _beginning;
  return true;
}




