#include <stdio.h>
#include <TimeSource/Driven.h>

#include <utils/ConfigFile.h>

TimeSource* create_TimeSource_driven(TimeSourceGenerator*,
                                     utils::ConfigFile* params,
                                     utils::SymbolTable*)
{
  return new DrivenTimeSource(params->getBool("exclusive", true));
}

DrivenTimeSource::DrivenTimeSource(bool exclusive)
{
  _exclusive = exclusive;
  _key_given = false;
}

bool DrivenTimeSource::getTime(utils::Time& t)
{
  t = _time;
  return _time != utils::Time::zero();
}

int DrivenTimeSource::getKey()
{
  if (!_exclusive || !_key_given) {
    _key_given = true;
    return 100;
  } else return 0;
}

bool DrivenTimeSource::setTime(const utils::Time& t, int key)
{
  if (key != 100)
    return false;

  _time = t;

  return true;
}

void DrivenTimeSource::setExtent(const utils::Time& beginning,
                              const utils::Time& ending)
{
  _beginning = beginning;
  _ending = ending;
}

bool DrivenTimeSource::getExtent(utils::Time& beginning, utils::Time& ending)
{
  ending = _ending;
  beginning = _beginning;
  return true;
}
